<?php
namespace App\Providers;
use App\Observers\PackageCountsObserver;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;
use App\Observers\GenerateTextObserver;
use App\Observers\PaymentLogsObserver;
use App\Observers\DissertationObserver;
use App\Observers\StripeHookObserver;
use App\Observers\ReferObserver;
use App\Models\Generate;
use App\Models\UserPackage;
use App\Models\PaymentLogs;
use App\Models\Dissertation;
use App\Models\StripeActivity;
use App\Models\Refer;
use App\Observers\UserPackageObserver;
use App\Models\PackageCounts;
use App\Models\User;
use App\Observers\UserObserver;
class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
               'stripe-webhooks::source.chargeable' => [
                    App\Listeners\ChargeSource::class,
                ],
        ],
        
    ];
    public function boot(): void
    {
        Generate::observe(GenerateTextObserver::class);
        UserPackage::observe(UserPackageObserver::class);
        PackageCounts::observe(PackageCountsObserver::class);
        PaymentLogs::observe(PaymentLogsObserver::class);
        Dissertation::observe(DissertationObserver::class);
        StripeActivity::observe(StripeHookObserver::class);
        Refer::observe(ReferObserver::class);
        User::observe(UserObserver::class);
    }
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
