<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Config;
use App\Models\SmtpSetting;

class ConfirmationMailToClient extends Mailable
{
    use Queueable, SerializesModels;

    public $result;
    public $smtpSettings;
    public $website;

    /**
     * Create a new message instance.
     */
    
    public function __construct($result, $date, $smtpSettings, $website)
    {
        $this->result = $result;
        $this->smtpSettings = $smtpSettings;
        $this->website = $website; // Ensure this contains correct Website data
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Order confirmation email'
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.client_order_confirmation_mail',
        );
    }

    /**
     * Configure the mail settings dynamically.
     */
    public function build()
    {
        // Configure the SMTP settings dynamically based on the provided smtpSettings
        if ($this->smtpSettings) {
            Config::set('mail.mailers.smtp.transport', $this->smtpSettings->mail_mailer);
            Config::set('mail.mailers.smtp.host', $this->smtpSettings->mail_host);
            Config::set('mail.mailers.smtp.port', $this->smtpSettings->mail_port);
            Config::set('mail.mailers.smtp.username', $this->smtpSettings->mail_username);
            Config::set('mail.mailers.smtp.password', $this->smtpSettings->mail_password);
            Config::set('mail.mailers.smtp.encryption', $this->smtpSettings->mail_encryption);
            Config::set('mail.from.address', $this->smtpSettings->mail_from_address);
            Config::set('mail.from.name', $this->smtpSettings->mail_from_name);
        }

        return $this->view('emails.client_order_confirmation_mail')
                    ->with(['result', $this->result, 'website', $this->website]);
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
