<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use App\Models\SmtpSetting;

class ClientOrderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $result;
    public $packagetype;
    public $smtpSettings;
 
    /**
     * Create a new message instance.
     */
    public function __construct($result,$packagetype, $smtpSettings)
    {
        $this->result = $result;
        $this->packagetype = $packagetype;
        $this->smtpSettings = $smtpSettings;
    }
    

    /**
     * Get the message envelope.
     */
    // public function envelope(): Envelope
    // {
       
    //     return new Envelope( subject: "New Order Recieved - {$this->packagetype->name} (\${$this->packagetype->amount})" );
    // }
    
    public function envelope(): Envelope
    {
        $name = $this->packagetype->name ?? '';
        $amount = $this->packagetype->amount ?? 0;
    
        return new Envelope(subject: "New Order Received - {$name} (\${$amount})");
    }
    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.client_order_mail',
        );
    }
    
    public function build()
    {
        // Configure the SMTP settings dynamically based on the provided smtpSettings
        if ($this->smtpSettings) {
            Config::set('mail.mailers.smtp.transport', $this->smtpSettings->mail_mailer);
            Config::set('mail.mailers.smtp.host', $this->smtpSettings->mail_host);
            Config::set('mail.mailers.smtp.port', $this->smtpSettings->mail_port);
            Config::set('mail.mailers.smtp.username', $this->smtpSettings->mail_username);
            Config::set('mail.mailers.smtp.password', $this->smtpSettings->mail_password);
            Config::set('mail.mailers.smtp.encryption', $this->smtpSettings->mail_encryption);
            Config::set('mail.from.address', $this->smtpSettings->mail_from_address);
            Config::set('mail.from.name', $this->smtpSettings->mail_from_name);
        }

        // Return the email view with the result and packagetype
        return $this->view('emails.client_order_mail')
                    ->with('result', $this->result)
                    ->with('packagetype', $this->packagetype);
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
     
     
     public function attachments(): array
{
    // Check if the file exists in the request
    if ($this->result instanceof Request && $this->result->hasFile('file')) {
        $files = $this->result->file('file');

        // Ensure $files is an array
        if (!is_array($files)) {
            $files = [$files];
        }

        // Iterate through each file and attach it
        foreach ($files as $file) {
            $fileName = $file->getClientOriginalName();
            $this->attach($file->getRealPath(), [
                'as' => $fileName,
                'mime' => $file->getMimeType(),
            ]);
        }

        // Return an empty array since we have attached the files already.
        return [];
    }

    return [];
}
public function attachments123(): array
    {
        // Check if the file exists in the request
        if ($this->result instanceof Request && $this->result->hasFile('file')) {
            $files = $this->result->file('file');
            foreach($files as $key=>$file){
                  $fileName = $file->getClientOriginalName();

                $this->attach($file->getRealPath(), [
                    'as' => $fileName,
                    'mime' => $file->getMimeType(),
                ]);
            }
          

            // Return an empty array since we have attached the file already.
            return [];
        }

        return [];
    }
}
