<?php
namespace App\Http\Traits;

use App\Models\Notifications;
use App\Models\User;
trait NotificationsTrait
{
    public function follow_notify($data)
    {
        if (isset($data)) {
            $notifications = new Notifications();
            $notifications->user_id = $data['user_id'];
            $users = new User();
            $follower_name = $users->find($data['user_id']);
            $followed_name = $users->find($data['followed_id']);
            $notifications->type = $data['type'];
            $date = date('Y-m-d');
            $notifications->message = json_encode([
                "id" => $data['followed_id'],
                "message" => "{$follower_name->name}, You have {$data['type']} the {$followed_name->name} on {$date}",
            ]);
            $save_notification = $notifications->save();
            $second_notifications = new Notifications();
            $second_notifications->message = json_encode([
                "id" => $data['user_id'],
                "message" => "{$follower_name->name}, {$data['type']} you on {$date}",
            ]);
            $second_notifications->user_id = $data['followed_id'];
            $second_notifications->type = $data['type'];
            $second_notifications->save();
        }
        return $this;
    }
    public function register_notify($data)
    {
        if (isset($data)) {
            $notifications = new Notifications();
            $notifications->user_id = $data['user_id'];
            $users = new User();
            $user_name = $users->find($data['user_id'])->name();
            $notifications->type = 'register_verified';
            $notifications->message = [
                "message" => "{$user_name}, your account verified successfully",
            ];
            $notifications->save();
        }
        return $this;
    }
    // public function course_notify($data){
    //   if(isset($data)){
    //       $notifications          = new Notifications();
    //       $notifications->user_id =  $data['user_id'];
    //       $users                  = new User();
    //       $user_name              = $users->find($data['user_id'])->name();
    //       // $notifications->type    = 'register_verified';
    //       // $notifications->message = [
    //       //                             "message"=>"{$user_name}, your account verified successfully"
    //       //                           ];
    //       // $notifications->save();
    //   }
    //   return $this;
    // }
    public function response($data)
    {
        return response()->json($data, 200);
    }
}
