<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\PackageRepositoryInterface;
use App\Http\Interfaces\PaymentRepositoryInterface;
use App\Http\Traits\PaymentLogsTrait;
use App\Http\Traits\PackageTrait;
use App\Models\Package;
use App\Models\UserPackage;
use App\Models\PaymentLogs;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class PaymentRepository implements PaymentRepositoryInterface
{
    use PaymentLogsTrait,PackageTrait;
    private $packageRepository;
    public function __construct(PackageRepositoryInterface $packageRepository)
    {
        $this->packageRepository = $packageRepository;
    }
    public function stripe_post($request)
    {
        $package = Package::find($request->package_id);
        $user =  auth('sanctum')->user();
        if ($user->id) {

            // $this->add_payment_logs_array($PaymentLogs,$request_data);
            \Stripe\Stripe::setApiKey('sk_test_AV5na9AOPRuBMHtCJN14dhSS');
            $session = \Stripe\Checkout\Session::create([
                'payment_method_types' => ['card'],
                'line_items'           => [
                    [
                        'price_data'  => [
                            'product_data' => [
                                'name' => $user->name,
                            ],
                            'unit_amount'  => ($package->amount) * 100,
                            'currency'     => 'USD',
                        ],
                        'quantity'    => 1,

                    ],
                ],
                'mode'                 => 'payment',
                 'success_url' => url('https://staggingdigiwiser.website/ai_project/dissertation_api/public/payment-success/{CHECKOUT_SESSION_ID}'),
                'cancel_url'           => 'https://staging.domyassignments.ai/cancel-payment' ,
            ]);
         

            // $this->add_payment_logs_array($PaymentLogs,$request_data);
         
            $PaymentLogs = new PaymentLogs();
            $request_data['package_id'] = $request->package_id;
            $request_data['user_id'] = $user->id;
            $request_data['status'] = "unpaid";
            $request_data['amount'] = $package->amount;
            $request_data['session_id'] = $session->id;
            $request_data['dissertation'] = $package->dissertation;
            $request_data['type'] = "subscription";
            $this->add_payment_logs_array($PaymentLogs,$request_data);


            return $session->url;
        } else {
            return false;
        }
    }

    public function stripe_success($request)
    {
        \Stripe\Stripe::setApiKey('sk_test_AV5na9AOPRuBMHtCJN14dhSS');
        $sessionId = $request->get('session_id');
        try {
            $session = \Stripe\Checkout\Session::retrieve($sessionId);
            if (!$session) {
                throw new NotFoundHttpException;
            }
            $PaymentLogs = PaymentLogs::where('session_id', $session->id)->first();
            if (!$PaymentLogs) {
                throw new NotFoundHttpException();
            }
            
            if ($PaymentLogs->status === 'unpaid') {
           
                $PaymentLogs->status = 'paid';
                $PaymentLogs->save();
            }


            //return view('product.checkout-success');
                   return redirect('https://staging.domyassignments.ai/success');
        } catch (\Exception $e) {
            throw new NotFoundHttpException();
        }
    }
}
