<?php

namespace App\Http\Controllers\API;

use App\Models\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\Mail\Message; // Add this line
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use App\Mail\CustomResetLinkMail;
use Closure; // Add this line for Closure type hint
use Carbon\Carbon;
class ResetPasswordController extends Controller
{
    public function sendResetLink(Request $request)
    {
        $request->validate(['email' => 'required|email']);
        $user = User::where('email', $request->email)->first();
        if (!$user) {
            return back()->withErrors(['email' => 'No user found with this email address']);
        }
        $response = $this->sendCustomResetLink($user);
        return $response == Password::RESET_LINK_SENT
            ? response()->json(['status'=>'success','message'=>'email sent to your email'])
            : response()->json(['status'=>'success','message'=>'something went wrong!']);
    }

    protected function sendCustomResetLink(User $user)
    {
        $token = app('auth.password.broker')->createToken($user);
        Mail::to($user->email)->send(new CustomResetLinkMail($token,$user->id));
        return Password::RESET_LINK_SENT;
    }
    
    public function check_token($token,$id)
    {
        try{
                $token = DB::table('password_reset_tokens') ->where('token','=',$token) ->where('created_at','>',Carbon::now()->subHours(2))->first();
                $user = User::find($id);
                return response()->json(['status'=>'success','data'=>$user]);
        }catch(\Exception $e){
              return response()->json(['status'=>'success','data'=>$e->getMessage()]);
        }
    }
}
