<?php
namespace App\Http\Traits;
use App\Models\Plan;
use App\Models\Website;
use Illuminate\Http\Request;

trait PlanTrait{

    // public function plans(){
    //     return Plan::all();
    // }

    public function plans(Request $request)
    {
        $website = Website::where('domain', $request->domain)->first();
    
        if (!$website) {
            $data['error'] = "Domain not found in websites table.";
            return response()->json($data, 404);
        }
    
        $plans = Plan::where('website_id', $website->id)->get();
        // dd($plans);
        if ($plans->isEmpty()) {
            return response()->json(['status' => 'error', 'message' => 'No plans found for this website.'], 404);
        }
    
        return $plans;
    }

    public function plan($id){
        return Plan::find($id);
    }
    public function plan_slug($slug){
        return Plan::where('slug',$slug)->first();
    }
    
    public function slug($request){
        return Plan::where('slug', $request->slug)->first();
    }
}
