<?php

namespace App\Http\Traits;

use App\Models\UserPackage;
use App\Models\Package;
use App\Models\PackageCounts;

trait PackageTrait
{

    private $user;
    public function __construct()
    {
        $this->user =  auth('sanctum')->user();
    }
    public function update_packages($generate)
    {
        $update = UserPackage::find($generate->user_package_id);
        $total_count = $update->total_counts;
        if ($total_count >= 1) {
            $total_count--;
        }
        $update->total_counts = $total_count;
        $update->save();
    }

    public function update_total_counts($userPackage)
    {
        $user_package = new PackageCounts();
        $user_package_counts = $user_package->where("user_id", $userPackage->user_id)->first();
        $new_counts = 0;
        if($userPackage->wasChanged('dissertation')){
            if ($user_package_counts) {
                $total_counts = $user_package_counts->dissertation;
                $new_counts = $total_counts-=1;
                $user_package_counts->dissertation = $new_counts;
                $user_package_counts->save();
            }
        }else{
            if ($user_package_counts) {
                $total_counts = $user_package_counts->total_counts;
                $new_counts = $total_counts-=1;
                $user_package_counts->total_counts = $new_counts;
                $user_package_counts->save();
            }
        }

        
    }
    public function add_total_counts($userPackage)
    {
        $user_package = new PackageCounts();
        $user_package_counts = $user_package->where("user_id", $userPackage->user_id)->first();
        $new_counts = 0;
        $new_dissertation=0;
        if ($user_package_counts) {
            $total_counts = $user_package_counts->total_counts;
            $dissertation = $user_package_counts->dissertation;
            $new_counts = $userPackage->total_counts + $total_counts;
            $new_dissertation = $userPackage->dissertation + $dissertation;
        } else {
            $user_package_counts = $user_package;
            $new_counts = $userPackage->total_counts;
            $new_dissertation = $userPackage->dissertation;
        }
        $user_package_counts->user_id = $userPackage->user_id;
        $user_package_counts->total_counts = $new_counts;
        $user_package_counts->dissertation = $new_dissertation;
        $user_package_counts->save();
    }
}
