<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\ReferRepositoryInterface;
use Vinkla\Hashids\Facades\Hashids;
use App\Models\Refer;
use Illuminate\Support\Facades\Hash;

class ReferRepository implements ReferRepositoryInterface
{
    public function random_strings($length_of_string)
    {
        $str_result = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcdefghijklmnopqrstuvwxyz';
        return substr(str_shuffle($str_result), 0, $length_of_string);
    }
    public function get()
    {
        $auth = auth('sanctum')->user();
        $data['status'] = 'error';
        $data['message'] = 'something went wrong!';
        if ($auth) {
            $random_text = rand();
            $refer_found = Refer::where(['user_id' => $auth->id])
                ->orderBy('id', 'desc')
                ->first();
            if ($refer_found) {
                $data['status'] = 'success';
                $data['message'] = 'refer link created!';
                $data['link'] = $refer_found->refer_encoded_code;
            } else {
                $refer = new Refer();
                $refer->user_id = $auth->id;
                $refer->hits = 1;
                $refer->dissertation = 1;
                $refer->refer_encoded_code = $this->random_strings($random_text);
                $refer->created_by = $auth->id;
                $refer->save();
                $data['status'] = 'success';
                $data['message'] = 'refer link created!';
                $data['link'] = $refer->refer_encoded_code;
            }
            return response()->json($data, 200);
        }
        return response()->json($data, 404);
    }
    public function set($request)
    {
        try {
            $refer = Refer::where('refer_encoded_code', $request->refer)->first();
            $data = [];
            if ($refer) {
                $data['status'] = 'success';
                $data['message'] = 'refer found successfully!';
                return response()->json($data, 200);
            } else {
                $data['status'] = 'error';
                $data['message'] = 'refer not found successfully!';
                return response()->json($data, 404);
            }
        } catch (\Exception $e) {
            $data['status'] = 'error';
            $data['message'] = $e->getMessage();
        }
    }
}
