<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Interfaces\GenerateTextRepositoryInterface;

class GeneratController extends Controller
{
    protected GenerateTextRepositoryInterface $generateTextRepositoryInterface;
    public function __construct(GenerateTextRepositoryInterface $generateTextRepositoryInterface)
    {
        $this->generateTextRepositoryInterface = $generateTextRepositoryInterface;
    }
    public function store(Request $request)
    {
        return $this->generateTextRepositoryInterface->generateText($request);
    }
    public function store_file(Request $request)
    {
        return $this->generateTextRepositoryInterface->upload_documents($request);
    }
    public function history(Request $request){
        return $this->generateTextRepositoryInterface->history_generator($request);
    }
    public function dissertation(Request $request){
        return $this->generateTextRepositoryInterface->generate_dissertation($request);
    }
    public function theises(Request $request){
        return $this->generateTextRepositoryInterface->theises($request);
    }
    public function generatelogo(Request $request){
        return $this->generateTextRepositoryInterface->generatelogo($request);
      
     }
     
      public function getSvg(Request $request){
        return $this->generateTextRepositoryInterface->generatesvg($request);
      
     }
      public function downloadUserIcon(Request $request){
        return $this->generateTextRepositoryInterface->downloadUserIcon($request);
      
     }
     public function userHistory(Request $request){
        return $this->generateTextRepositoryInterface->userHistory($request);
      
     }
}
