<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
class CheckUserPackageExists
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user_package = auth('sanctum')->user();
        // dd($user_package->user_total_hits);
        if($user_package){
            $user_packages= $user_package;
            if($user_packages->user_total_hits){
                if($user_packages->user_total_hits&&$user_packages->user_total_hits->total_counts>=1){
                    return $next($request);
                }else{
                    return response(['status'=>'error','text'=>'No more hits found!'], 409);
                }
            }else{
                return response(['status'=>'error','text'=>'No Package Found!'], 404);
            }
        }else{
            return response(['status'=>'error','text'=>'User Not Found!'], 404);
        }
    }
}
